/*
	BinMaker program
	Copyright 2007 Jonathan Wilson
	Portions lifted from BinOpener copyright 2007 booto (temptemp91 at hotmail dot com)

	This file is part of binmaker.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	binmaker is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/
struct GameMapWaypoint {
	unsigned int id_hash;
	unsigned int import;
	unsigned int z1;
	unsigned int z2;
	float x;
	float y;
	float z;
};

struct GameMapThing {
	unsigned int id_hash;
	unsigned int import;
	unsigned int zero;
	float angle;
	float x;
	float y;
	float z;
	list_lo faction;
	list_lo team;
	float health;
	list_lo event_list;
};

struct Thing {
	unsigned int id_hash;
	ExtraEntry import;
	float angle;
	float x;
	float y;
	float z;
	const char *faction;
	const char *team;
	float health;
};

struct GameMapAudio {
	unsigned int id_hash;
	unsigned int import;
	unsigned int z1;
	unsigned int z2;
	float x;
	float y;
	float z;
};

struct Audio {
	unsigned int id_hash;
	ExtraEntry import;
	unsigned int z1;
	unsigned int z2;
	float x;
	float y;
	float z;
};

struct EnvData {
	ExtraEntry cloud_imp;
	ExtraEntry noise_imp;
	ExtraEntry envir_imp;
};

struct GameMapEnvData {
	unsigned int cloud_imp;
	unsigned int noise_imp;
	unsigned int envir_imp;
};

template <class Type> struct GameMapProperty {
	list_lo name;
	Type value;
};

template <class Type> struct Property {
	const char *name;
	Type value;
};

struct GameMapWorldDict {
	list_lo bool_prop;
	list_lo int_prop;
	list_lo real_prop;
	list_lo string_prop;
	list_lo unicodestring_prop;
	list_lo asset_prop;
	list_lo assetlist_prop;
};
struct GameMapHeader {
	unsigned int zeroes;
	list_lo waypoints;
	list_lo structures;
	list_lo units;
	list_lo props;
	list_lo audio;
	list_lo unknown;
	list_lo roads;
	offset_o env;
	offset_o dict;
	list_lo posteffects;
};

class GameMap: public ManifestItem {
	unsigned int offset;
	unsigned int currentimport;
	Thing *ParseThing(TiXmlNode *child);
	void StoreThing(GameMapThing *th,Thing *th2);
public:
	GameMap(TiXmlNode *node);
};
