/*
	BinMaker program
	Copyright 2007 Jonathan Wilson
	Portions lifted from BinOpener and TerrainTextureCompiler copyright 2007 booto (temptemp91 at hotmail dot com)

	This file is part of binmaker.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	binmaker is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#ifndef BIGAXES_H_INCLUDED
#define BIGAXES_H_INCLUDED
#include <stdio.h>
#include <list>
#include <string>

#ifdef __cplusplus
extern "C" {
#endif

struct _BIGFile;

typedef struct {
	struct _BIGFile *container;
	unsigned int offset;
	unsigned int size;
	unsigned int un_size;
	std::string name;
	unsigned char *content;
} BIGFileEntry;

typedef struct _BIGFile {
	HANDLE file;
	unsigned int magic;
	unsigned int num_elems;
	BIGFileEntry * entries;
} BIGFile;

BIGFile *BigOpen(const LPCSTR filename);
void BigClose(BIGFile *bf);
BIGFileEntry *BigGetEntry(BIGFile *bf, int entry);
BIGFileEntry *BigGetEntryByName(BIGFile *bf, const char *name);
unsigned int BigGetNumElements(BIGFile *bf);
BIGFileEntry *BigLoadEntry(BIGFile *bf, int entry);
BIGFileEntry *BigLoadEntryByName(BIGFile *bf, const char *name);

#ifdef __cplusplus
}
#endif

#endif // BIGAXES_H_INCLUDED
