/*
	BinMaker program
	Copyright 2007 Jonathan Wilson
	Portions lifted from BinOpener and TerrainTextureCompiler copyright 2007 booto (temptemp91 at hotmail dot com)

	This file is part of binmaker.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	binmaker is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#ifndef TERRAINTEXTUREATLAS_H_INCLUDED
#define TERRAINTEXTUREATLAS_H_INCLUDED

#include "common.h"
#include "tinyxml.h"

struct TerrainTexture {
	D3DXIMAGE_INFO d_inf;
	LPDIRECT3DTEXTURE9 diffuse;
	D3DXIMAGE_INFO n_inf;
	LPDIRECT3DTEXTURE9 normal;
	unsigned int id;
};

struct A8R8G8B8_s {
	unsigned char b;
	unsigned char g;
	unsigned char r;
	unsigned char a;
};

struct TerrainTextureEntry {
	unsigned int id;
	unsigned short x1;
	unsigned short y1;
	unsigned short x2;
	unsigned short y2;
	void width(unsigned short w)
	{
		x2 = x1 + w;
	}
	unsigned short width()
	{
		return x2-x1;
	}
	void height(unsigned short h)
	{
		y2 = y1 + h;
	}
	unsigned short height()
	{
		return y2-y1;
	}
};

class TerrainTextureAtlas: public ManifestItem {
public:
	TerrainTextureAtlas(TiXmlNode *node);
};

#endif // TERRAINTEXTUREATLAS_H_INCLUDED
