/*
	BinMaker program
	Copyright 2007 Jonathan Wilson
	Portions lifted from BinOpener copyright 2007 booto (temptemp91 at hotmail dot com)

	This file is part of binmaker.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	binmaker is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/
#include <vector>
#include "manifest.h"

struct list_lo {
	unsigned int length;
	unsigned int offset;
};

struct offset_o {
    unsigned int offset;
};

struct ManifestItemHeader {
  unsigned int filenamehash1;
  unsigned int filenamehash2;
  unsigned int filenamehash3;
  unsigned int filenamehash4;
  unsigned int extraentryoffset;
  unsigned int extraentrycount;
  unsigned int streamnameoffset;
  unsigned int sourcenameoffset;
  unsigned int streamsize;
  unsigned int reloentrysize;
  unsigned int impentrysize;
};

struct ExtraEntry {
  unsigned int filehash1;
  unsigned int filehash2;
};

class ManifestItem {
protected:
	ManifestItemHeader Header;
	const char *StreamName;
	const char *SourceName;
	char *StreamData;
	unsigned int StreamSize;
	std::vector<ExtraEntry *> ExtraEntries;
	std::vector<unsigned int> ImpEntries;
public:
	std::vector<unsigned int> RelocationEntries;
	void calcsize(ManifestFile *m);
	void save(ManifestFile *m);
	void AddImport(unsigned int filehash1,unsigned int filehash2,unsigned int import);
};

unsigned long hash_function(const char *input, int length);
