/*
	BinMaker program
	Copyright 2007 Jonathan Wilson
	Portions lifted from BinOpener copyright 2007 booto (temptemp91 at hotmail dot com)

	This file is part of binmaker.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	binmaker is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/
#include <stdio.h>
#include "manifestitem.h"
#include "logiccommandset.h"

LogicCommandSet::LogicCommandSet(const char *streamname,const char *sourcename,unsigned int hash2, unsigned int hash4, unsigned int count)
{
	StreamName = _strdup(streamname);
	SourceName = _strdup(sourcename);
	Header.filenamehash1 = 0xec066d65;
	Header.filenamehash2 = hash2;
	Header.filenamehash3 = 0x6d148bd7;
	Header.filenamehash4 = hash4;
	StreamSize = 12 + (count * 4);
	StreamData = new char[StreamSize];
	memset(StreamData,0,StreamSize);
	((unsigned int *)StreamData)[0] = 0;
	((unsigned int *)StreamData)[1] = count;
	((unsigned int *)StreamData)[2] = 0xC;
	for (unsigned int i = 0;i < count;i++)
	{
		((unsigned int *)StreamData)[i+3] = i;
	}
	RelocationEntries.push_back(0x8);
}
