/*
	BinMaker program
	Copyright 2007 Jonathan Wilson
	Portions lifted from BinOpener and TerrainTextureCompiler copyright 2007 booto (temptemp91 at hotmail dot com)

	This file is part of binmaker.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	binmaker is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winsock2.h>
#include "bigaxes.h"

unsigned char *ProcessRefpack(unsigned char *inbuf, unsigned int *size);

BIGFileEntry *BigLoadEntry(BIGFile *bf, int entry)
{
	unsigned char *tmp;
	if(bf->entries[entry].content)
	{
		return &bf->entries[entry];
	}
	SetFilePointer(bf->file, bf->entries[entry].offset, NULL, FILE_BEGIN);
	tmp = new unsigned char[bf->entries[entry].size];
	DWORD num_bytes;
	ReadFile(bf->file, tmp, bf->entries[entry].size, &num_bytes, NULL);
	bf->entries[entry].un_size = bf->entries[entry].size;
	bf->entries[entry].content = ProcessRefpack(tmp, &bf->entries[entry].un_size);
	delete[] tmp;
	return &bf->entries[entry];
}

void BigClose(BIGFile *bf)
{
	for(unsigned int i=0; i<bf->num_elems; i++)
	{
		delete[] bf->entries[i].content;
	}
	delete[] bf->entries;
	delete bf;
}

BIGFileEntry *BigLoadEntryByName(BIGFile *bf, const char *name)
{
	for(unsigned int i=0; i<bf->num_elems; i++)
	{
		if(_stricmp(name, bf->entries[i].name.c_str()) == 0)
		{
			return BigLoadEntry(bf, i);
		}
	}
	return NULL;
}

BIGFileEntry *BigGetEntryByName(BIGFile *bf, const char *name)
{
	for(unsigned int i=0; i<bf->num_elems; i++)
	{
		if(_stricmp(name, bf->entries[i].name.c_str()) == 0)
		{
			return &bf->entries[i];
		}
	}
	return NULL;
}
BIGFileEntry *BigGetEntry(BIGFile *bf, int entry)
{
	return &bf->entries[entry];
}

unsigned int BigGetNumElements(BIGFile *bf)
{
	return bf->num_elems;
}

BIGFile *BigOpen(const LPCSTR filename)
{
	BIGFile *bf;
	bf = new BIGFile();
	if (bf==NULL)
	{
		return NULL;
	}
	bf->file = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (bf->file == INVALID_HANDLE_VALUE)
	{
		delete bf;
		return NULL;
	}
	DWORD num_bytes;
	if (ReadFile(bf->file, &bf->magic, 4, &num_bytes, NULL) == 0)
	{
		CloseHandle(bf->file);
		delete bf;
		return NULL;
	}
	if (ntohl(bf->magic) != 0x42494734)
	{
		CloseHandle(bf->file);
		delete bf;
		return NULL;
	}
	SetFilePointer(bf->file, 0x8, NULL, FILE_BEGIN);
	if (ReadFile(bf->file, &bf->num_elems, 4, &num_bytes, NULL) == 0)
	{
		CloseHandle(bf->file);
		delete bf;
		return NULL;
	}
	bf->num_elems = ntohl(bf->num_elems);
	bf->entries = new BIGFileEntry[bf->num_elems];
	SetFilePointer(bf->file, 0x10, NULL, FILE_BEGIN);
	for (unsigned int i=0; i<bf->num_elems; i++)
	{
		ReadFile(bf->file, &bf->entries[i].offset, 4, &num_bytes, NULL);
		bf->entries[i].offset = htonl(bf->entries[i].offset);
		ReadFile(bf->file, &bf->entries[i].size, 4, &num_bytes, NULL);
		bf->entries[i].size = htonl(bf->entries[i].size);
		char n[2];
		n[1] = 0x00;
		ReadFile(bf->file, n, 1, &num_bytes, NULL);
		while (*n != 0x00)
		{
			bf->entries[i].name.append(n);
			ReadFile(bf->file, n, 1, &num_bytes, NULL);
		}
		bf->entries[i].container = bf;
		bf->entries[i].content = NULL;
	}
	return bf;
}
