/*
	BinMaker program
	Copyright 2007 Jonathan Wilson
	Portions lifted from BinOpener copyright 2007 booto (temptemp91 at hotmail dot com)

	This file is part of binmaker.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	binmaker is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/
struct MissionObjectivePresentation {
	list_lo name; //char
	unsigned int import;
	offset_o a; //float
	offset_o b; //float
	offset_o c; //float
	offset_o d; //float
	offset_o e; //float
	unsigned int unknown;
};

struct ObjectivePresentation {
	const char *name;
	ExtraEntry import;
	float a;
	float b;
	float c;
	float d;
	float e;
	unsigned int unknown;
};

struct MissionObjective {
	list_lo name; //char
	list_lo detail; //char
	list_lo obj; //MissionObjectivePresentation
	unsigned int bonus;
};

struct Objective {
	const char *name;
	const char *detail;
	std::vector<ObjectivePresentation *> obj;
	unsigned int bonus;
};

struct MissionObjectiveListHeader {
	unsigned int zeroes;
	list_lo scripts; //MissionObjective
};

class MissionObjectiveList: public ManifestItem {
	unsigned int offset;
	unsigned int currentimport;
public:
	MissionObjectiveList(TiXmlNode *node);
};
