/*
	BinMaker program
	Copyright 2007 Jonathan Wilson
	Portions lifted from BinOpener copyright 2007 booto (temptemp91 at hotmail dot com)

	This file is part of binmaker.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	binmaker is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/
struct GSLHeader {
	unsigned int zero;
	unsigned int rootoffset;
};

struct GSLObject {
	unsigned int hash;
	unsigned int value;
};

struct GSLParameterList {
	unsigned int offset; //GSLObject
};

struct GSLAction {
	unsigned int hash;
	list_lo parameterlist; //GSLParameterList
};

struct GSLScript {
	unsigned int hash;
	list_lo actions; //GSLAction
};

struct GSLScriptGroup {
	unsigned int hash;
	list_lo scripts; //GSLScript
	list_lo scriptgroups; //GSLScriptGroup
};

struct Action {
	unsigned int hash;
	GSLObject object;
	ExtraEntry e;
};

struct Script {
	unsigned int hash;
	std::vector<Action *> actions;
};

struct ScriptGroup {
	unsigned int hash;
	std::vector<Script *> scripts;
	std::vector<ScriptGroup *> scriptgroups;
};

class GameScriptList: public ManifestItem {
	unsigned int offset;
	unsigned int currentimport;
	ScriptGroup *ParseScriptGroup(TiXmlNode *node);
	Script *ParseScript(TiXmlNode *node);
	Action *ParseAction(TiXmlNode *node);
	void StoreScriptGroup(ScriptGroup *scriptgroup,unsigned int sgoffset);
	void StoreScript(Script *script,unsigned int scoffset);
	void StoreAction(Action *action,unsigned int aoffset);
public:
	GameScriptList(TiXmlNode *node);
};
