unit Manifest_File;

// Library to possibly read Manifest packages from C&C3.
// This is a work in progress that is being written so far by Carlos
// "Banshee" Muniz.

interface

uses BasicDataTypes;

type
   TManifestHeader = record
      Version : uint32;   //$050100
      Signature : uint32;
      ManifestSignature : uint32; // F54ABCCF
      ItemCount : uint32;
      BinSize: uint32;
      Unknown1: uint32;
      ReloSize: uint32;
      ImpSize: uint32;
      ExtraEntriesSize: uint32;
      IncludeNameSize: uint32;
      StreamNameSize: uint32;
      SourceNameSize: uint32;
   end;

   TManifestFileHeader = record
      FilenameHash1 : uint32;
      FilenameHash2 : uint32;
      FilenameHash3 : uint32;
      FilenameHash4 : uint32;
      ExtraEntryOffset : uint32;
      ExtraEntryCount : uint32;
      StreamNameOffset : uint32;
      SourceNameOffset : uint32;
      StreamSize : uint32;
      ReloEntrySize : uint32;
      ExtraEntrySize : uint32;
      // We grab this one in the end.
      Name : string;
   end;

   TManifestPackage = class
      public
         // Constructors and Destructors
         constructor Create;
         destructor Destroy; override;
         // Gets
         // Sets

      private
         Valid : Boolean;
         Files : array of TManifestFileHeader;
         MainHeader : TManifestHeader;
         // I/O
         procedure LoadFileFromBuffers(const PManifestBuffer, PImpBuffer, PReloBuffer, PBinBuffer: puint8);
   end;


implementation

constructor TManifestPackage.Create;
begin
   SetLength(Files,0);
   Valid := false;
end;

destructor TManifestPackage.Destroy;
begin
   SetLength(Files,0);
   inherited Destroy;
end;

procedure TManifestPackage.LoadFileFromBuffers (const PManifestBuffer, PImpBuffer, PReloBuffer, PBinBuffer: puint8);
var
   PMan,PBin,PImp,PRel : puint8;
begin
   PMan := PManifestBuffer;
   PImp := PImpBuffer;
   PRel := PReloBuffer;
   PBin := PBinBuffer;

   // Let's read the manifest

end;

end.
